## 1 Timing Assertions Section
# 1.1 Primary clocks
create_clock -period 20.000 -name UC_REB_IN [get_ports UC_REB_IN]
create_clock -period 20.000 -name UC_WEB_IN [get_ports UC_WEB_IN]
create_clock -period 8.000 -name LAN1_RXC [get_ports LAN_RXC]
create_clock -period 8.000 -name LAN2_RXC [get_ports LEFT_CONNECTOR_A[1]]
create_clock -period 8.000 -name LAN3_RXC [get_ports LEFT_CONNECTOR_A[19]]
create_clock -period 100.000 -name CLK10g [get_pins REF_CLK_GEN_002.CLKGEN7C_001/clkout1_buf/O]
create_clock -period 8.333 -name CLK_P [get_pins BUFG_004/O]
create_clock -period 52.083 -name CLKREF_TCXO [get_ports CLKREF_TCXO]

set_property CLOCK_DEDICATED_ROUTE FALSE [get_nets CLKREF_TCXO]
set_property CLOCK_DEDICATED_ROUTE FALSE [get_nets CLKREF_EXT]
set_property CLOCK_DEDICATED_ROUTE FALSE [get_nets LAN_RXC]
set_property CLOCK_DEDICATED_ROUTE FALSE [get_nets UC_REB_IN]
set_property CLOCK_DEDICATED_ROUTE FALSE [get_nets UC_WEB_IN]

# 1.2 generated clocks

# 1.3 Forwarded clocks
create_generated_clock -name LAN1_TXC -source [get_pins LAN_001/IF_SEL_001.Inst_RGMII_WRAPPER/ODDR2_TX_003_7.ODDR_inst/C] -divide_by 1 [get_ports LAN_TXC]
create_generated_clock -name LAN2_TXC -source [get_pins LAN_002/IF_SEL_001.Inst_RGMII_WRAPPER/ODDR2_TX_003_7.ODDR_inst/C] -divide_by 1 [get_ports LEFT_CONNECTOR_A[7]]
create_generated_clock -name LAN3_TXC -source [get_pins LAN_003/IF_SEL_001.Inst_RGMII_WRAPPER/ODDR2_TX_003_7.ODDR_inst/C] -divide_by 1 [get_ports LEFT_CONNECTOR_A[25]]

# 1.4 Input and output delay constraints
set_input_delay -clock [get_clocks LAN1_RXC] -clock_fall -min -add_delay 3.300 [get_ports {LAN_RXD[*]}]
set_input_delay -clock [get_clocks LAN1_RXC] -clock_fall -max -add_delay 4.300 [get_ports {LAN_RXD[*]}]
set_input_delay -clock [get_clocks LAN1_RXC] -min -add_delay 3.300 [get_ports {LAN_RXD[*]}]
set_input_delay -clock [get_clocks LAN1_RXC] -max -add_delay 4.300 [get_ports {LAN_RXD[*]}]
set_output_delay -clock [get_clocks LAN1_TXC] -clock_fall -min -add_delay 0.300 [get_ports {LAN_TXD[*]}]
set_output_delay -clock [get_clocks LAN1_TXC] -clock_fall -max -add_delay 1.300 [get_ports {LAN_TXD[*]}]
set_output_delay -clock [get_clocks LAN1_TXC] -min -add_delay 0.300 [get_ports {LAN_TXD[*]}]
set_output_delay -clock [get_clocks LAN1_TXC] -max -add_delay 1.300 [get_ports {LAN_TXD[*]}]

set_input_delay -clock [get_clocks LAN2_RXC] -clock_fall -min -add_delay 3.300 [get_ports {LEFT_CONNECTOR_A[2] LEFT_CONNECTOR_A[3] LEFT_CONNECTOR_A[4] LEFT_CONNECTOR_A[5] LEFT_CONNECTOR_A[6]}]
set_input_delay -clock [get_clocks LAN2_RXC] -clock_fall -max -add_delay 4.300 [get_ports {LEFT_CONNECTOR_A[2] LEFT_CONNECTOR_A[3] LEFT_CONNECTOR_A[4] LEFT_CONNECTOR_A[5] LEFT_CONNECTOR_A[6]}]
set_input_delay -clock [get_clocks LAN2_RXC] -min -add_delay 3.300 [get_ports {LEFT_CONNECTOR_A[2] LEFT_CONNECTOR_A[3] LEFT_CONNECTOR_A[4] LEFT_CONNECTOR_A[5] LEFT_CONNECTOR_A[6]}]
set_input_delay -clock [get_clocks LAN2_RXC] -max -add_delay 4.300 [get_ports {LEFT_CONNECTOR_A[2] LEFT_CONNECTOR_A[3] LEFT_CONNECTOR_A[4] LEFT_CONNECTOR_A[5] LEFT_CONNECTOR_A[6]}]
set_output_delay -clock [get_clocks LAN2_TXC] -clock_fall -min -add_delay 0.300 [get_ports {LEFT_CONNECTOR_A[8] LEFT_CONNECTOR_A[9] LEFT_CONNECTOR_A[10] LEFT_CONNECTOR_A[11] LEFT_CONNECTOR_A[12]}]
set_output_delay -clock [get_clocks LAN2_TXC] -clock_fall -max -add_delay 1.300 [get_ports {LEFT_CONNECTOR_A[8] LEFT_CONNECTOR_A[9] LEFT_CONNECTOR_A[10] LEFT_CONNECTOR_A[11] LEFT_CONNECTOR_A[12]}]
set_output_delay -clock [get_clocks LAN2_TXC] -min -add_delay 0.300 [get_ports {LEFT_CONNECTOR_A[8] LEFT_CONNECTOR_A[9] LEFT_CONNECTOR_A[10] LEFT_CONNECTOR_A[11] LEFT_CONNECTOR_A[12]}]
set_output_delay -clock [get_clocks LAN2_TXC] -max -add_delay 1.300 [get_ports {LEFT_CONNECTOR_A[8] LEFT_CONNECTOR_A[9] LEFT_CONNECTOR_A[10] LEFT_CONNECTOR_A[11] LEFT_CONNECTOR_A[12]}]

set_input_delay -clock [get_clocks LAN3_RXC] -clock_fall -min -add_delay 3.300 [get_ports {LEFT_CONNECTOR_A[20] LEFT_CONNECTOR_A[21] LEFT_CONNECTOR_A[22] LEFT_CONNECTOR_A[23] LEFT_CONNECTOR_A[24]}]
set_input_delay -clock [get_clocks LAN3_RXC] -clock_fall -max -add_delay 4.300 [get_ports {LEFT_CONNECTOR_A[20] LEFT_CONNECTOR_A[21] LEFT_CONNECTOR_A[22] LEFT_CONNECTOR_A[23] LEFT_CONNECTOR_A[24]}]
set_input_delay -clock [get_clocks LAN3_RXC] -min -add_delay 3.300 [get_ports {LEFT_CONNECTOR_A[20] LEFT_CONNECTOR_A[21] LEFT_CONNECTOR_A[22] LEFT_CONNECTOR_A[23] LEFT_CONNECTOR_A[24]}]
set_input_delay -clock [get_clocks LAN3_RXC] -max -add_delay 4.300 [get_ports {LEFT_CONNECTOR_A[20] LEFT_CONNECTOR_A[21] LEFT_CONNECTOR_A[22] LEFT_CONNECTOR_A[23] LEFT_CONNECTOR_A[24]}]
set_output_delay -clock [get_clocks LAN3_TXC] -clock_fall -min -add_delay 0.300 [get_ports {LEFT_CONNECTOR_A[26] LEFT_CONNECTOR_A[27] LEFT_CONNECTOR_A[28] LEFT_CONNECTOR_A[29] LEFT_CONNECTOR_A[30]}]
set_output_delay -clock [get_clocks LAN3_TXC] -clock_fall -max -add_delay 1.300 [get_ports {LEFT_CONNECTOR_A[26] LEFT_CONNECTOR_A[27] LEFT_CONNECTOR_A[28] LEFT_CONNECTOR_A[29] LEFT_CONNECTOR_A[30]}]
set_output_delay -clock [get_clocks LAN3_TXC] -min -add_delay 0.300 [get_ports {LEFT_CONNECTOR_A[26] LEFT_CONNECTOR_A[27] LEFT_CONNECTOR_A[28] LEFT_CONNECTOR_A[29] LEFT_CONNECTOR_A[30]}]
set_output_delay -clock [get_clocks LAN3_TXC] -max -add_delay 1.300 [get_ports {LEFT_CONNECTOR_A[26] LEFT_CONNECTOR_A[27] LEFT_CONNECTOR_A[28] LEFT_CONNECTOR_A[29] LEFT_CONNECTOR_A[30]}]

## 2 Timing Exceptions Section
# The following cross clock domain false path constraints can be uncommented in order to mimic ucf constraints behavior (see message at the beginning of this file)
set_false_path -from [get_clocks UC_REB_IN] -to [get_clocks {CLK_P UC_WEB_IN}]
set_false_path -from [get_clocks UC_WEB_IN] -to [get_clocks {CLK10g CLK_P UC_REB_IN }]
set_false_path -from [get_clocks CLK_P] -to [get_clocks {LAN1_RXC LAN2_RXC LAN3_RXC UC_WEB_IN CLK10g DNA_ID_001/n_0_CLK_DIV2_reg}]
set_false_path -from [get_clocks CLK10g] -to [get_clocks {CLK_P UC_REB_IN}]
set_false_path -from [get_clocks LAN1_RXC] -to [get_clocks {CLK_P}]
set_false_path -from [get_clocks LAN2_RXC] -to [get_clocks {CLK_P}]
set_false_path -from [get_clocks LAN3_RXC] -to [get_clocks {CLK_P}]

#----------------------------------------------------------------
# BUILT-IN ETHERNET LAN1
#----------------------------------------------------------------
# strap-in configuration. Micrel KSZ9031RN
# advertise all capabilities: 10/100/1000
set_property PULLUP true [get_ports {LAN_RXD[0]}]
set_property PULLUP true [get_ports {LAN_RXD[1]}]
set_property PULLUP true [get_ports {LAN_RXD[2]}]
set_property PULLUP true [get_ports {LAN_RXD[3]}]
## advertize limited capabilities
#set_property PULLDOWN true [get_ports {LAN_RXD[0]}]
#set_property PULLUP true [get_ports {LAN_RXD[1]}]
#set_property PULLUP true [get_ports {LAN_RXD[2]}]
#set_property PULLUP true [get_ports {LAN_RXD[3]}]

# disable 125 MHz clock reference to FPGA
set_property PULLDOWN true [get_ports LAN_RX_CTL]
# dual LED mode
set_property PULLDOWN true [get_ports LAN_CLK125]
# PHYAD2   This PHY address is 7
set_property PULLUP true [get_ports LAN_RXC]
set_property PULLUP true [get_ports LAN_MDIO]
set_property PULLUP true [get_ports LAN_INT_N]


set_property PACKAGE_PIN V22 [get_ports LAN_RXC]
set_property PACKAGE_PIN T21 [get_ports LAN_RX_CTL]
set_property PACKAGE_PIN U21 [get_ports {LAN_RXD[0]}]
set_property PACKAGE_PIN P19 [get_ports {LAN_RXD[1]}]
set_property PACKAGE_PIN R19 [get_ports {LAN_RXD[2]}]
set_property PACKAGE_PIN T19 [get_ports {LAN_RXD[3]}]
set_property PACKAGE_PIN N15 [get_ports LAN_TXC]
set_property PACKAGE_PIN P20 [get_ports LAN_TX_CTL]
set_property PACKAGE_PIN P22 [get_ports {LAN_TXD[0]}]
set_property PACKAGE_PIN R22 [get_ports {LAN_TXD[1]}]
set_property PACKAGE_PIN P21 [get_ports {LAN_TXD[2]}]
set_property PACKAGE_PIN R21 [get_ports {LAN_TXD[3]}]
set_property PACKAGE_PIN J16 [get_ports LAN_RESET_N]
set_property PACKAGE_PIN K19 [get_ports LAN_MCLK]
set_property PACKAGE_PIN M17 [get_ports LAN_MDIO]
set_property PACKAGE_PIN W20 [get_ports LAN_CLK125]
set_property PACKAGE_PIN U18 [get_ports LAN_INT_N]

set_property IOSTANDARD LVCMOS15 [get_ports LAN_RXC]
set_property IOSTANDARD LVCMOS15 [get_ports LAN_RX_CTL]
set_property IOSTANDARD LVCMOS15 [get_ports {LAN_RXD[0]}]
set_property IOSTANDARD LVCMOS15 [get_ports {LAN_RXD[1]}]
set_property IOSTANDARD LVCMOS15 [get_ports {LAN_RXD[3]}]
set_property IOSTANDARD LVCMOS15 [get_ports {LAN_RXD[2]}]
set_property IOSTANDARD LVCMOS15 [get_ports LAN_TXC]
set_property IOSTANDARD LVCMOS15 [get_ports LAN_TX_CTL]
set_property IOSTANDARD LVCMOS15 [get_ports {LAN_TXD[3]}]
set_property IOSTANDARD LVCMOS15 [get_ports {LAN_TXD[2]}]
set_property IOSTANDARD LVCMOS15 [get_ports {LAN_TXD[1]}]
set_property IOSTANDARD LVCMOS15 [get_ports {LAN_TXD[0]}]
set_property IOSTANDARD LVCMOS15 [get_ports LAN_RESET_N]
set_property IOSTANDARD LVCMOS15 [get_ports LAN_MCLK]
set_property IOSTANDARD LVCMOS15 [get_ports LAN_MDIO]
set_property IOSTANDARD LVCMOS15 [get_ports LAN_CLK125]
set_property IOSTANDARD LVCMOS15 [get_ports LAN_INT_N]

#----------------------------------------------------------------
# SERIAL DAC
#----------------------------------------------------------------
set_property PACKAGE_PIN Y16 [get_ports DAC_SCLK]
set_property PACKAGE_PIN Y17 [get_ports DAC_SDIN]
set_property PACKAGE_PIN AA16 [get_ports DAC_SYNC_B]

set_property IOSTANDARD LVCMOS33 [get_ports DAC_SCLK]
set_property IOSTANDARD LVCMOS33 [get_ports DAC_SDIN]
set_property IOSTANDARD LVCMOS33 [get_ports DAC_SYNC_B]

#----------------------------------------------------------------
# EXTERNAL GIGABIT ETHERNET LAN2
#----------------------------------------------------------------
# COM-5401/5102 plug-in module through LEFT_CONNECTOR_A()
# strap-in configuration. Micrel KSZ9021RN
# advertise all capabilities: 10/100/1000
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[3]]
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[4]]
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[5]]
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[6]]
# disable 125 MHz clock reference to FPGA
set_property PULLDOWN true [get_ports LEFT_CONNECTOR_A[2]]
# dual LED mode
set_property PULLDOWN true [get_ports LEFT_CONNECTOR_A[13]]
# PHYAD2   This PHY address is 4
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[1]]

set_property PACKAGE_PIN AB1 [get_ports {LEFT_CONNECTOR_A[1]}]
set_property PACKAGE_PIN AA1 [get_ports {LEFT_CONNECTOR_A[2]}]
set_property PACKAGE_PIN AA3 [get_ports {LEFT_CONNECTOR_A[3]}]
set_property PACKAGE_PIN Y3 [get_ports {LEFT_CONNECTOR_A[4]}]
set_property PACKAGE_PIN AB5 [get_ports {LEFT_CONNECTOR_A[5]}]
set_property PACKAGE_PIN AA5 [get_ports {LEFT_CONNECTOR_A[6]}]
set_property PACKAGE_PIN AA6 [get_ports {LEFT_CONNECTOR_A[7]}]
set_property PACKAGE_PIN Y6 [get_ports {LEFT_CONNECTOR_A[8]}]
set_property PACKAGE_PIN AB8 [get_ports {LEFT_CONNECTOR_A[9]}]
set_property PACKAGE_PIN AA8 [get_ports {LEFT_CONNECTOR_A[10]}]
set_property PACKAGE_PIN Y9 [get_ports {LEFT_CONNECTOR_A[11]}]
set_property PACKAGE_PIN W9 [get_ports {LEFT_CONNECTOR_A[12]}]
set_property PACKAGE_PIN T3 [get_ports {LEFT_CONNECTOR_A[13]}]
set_property PACKAGE_PIN U7 [get_ports {LEFT_CONNECTOR_A[14]}]
set_property PACKAGE_PIN F4 [get_ports {LEFT_CONNECTOR_A[15]}]
set_property PACKAGE_PIN L6 [get_ports {LEFT_CONNECTOR_A[16]}]
set_property PACKAGE_PIN AB15 [get_ports {LEFT_CONNECTOR_A[17]}]

set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[1]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[2]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[3]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[4]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[5]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[6]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[7]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[8]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[9]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[10]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[11]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[12]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[13]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[14]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[15]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[16]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[17]}]

set_property DRIVE 12 [get_ports {RIGHT_CONNECTOR_A[7]}]
set_property SLEW FAST [get_ports {RIGHT_CONNECTOR_A[7]}]

#----------------------------------------------------------------
# EXTERNAL GIGABIT ETHERNET LAN3
#----------------------------------------------------------------
# COM-5401/5102 plug-in module through LEFT_CONNECTOR_A()
# strap-in configuration. Micrel KSZ9021RN
# advertise all capabilities: 10/100/1000
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[21]]
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[22]]
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[23]]
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[24]]
# disable 125 MHz clock reference to FPGA
set_property PULLDOWN true [get_ports LEFT_CONNECTOR_A[20]]
# dual LED mode
set_property PULLDOWN true [get_ports LEFT_CONNECTOR_A[31]]
# PHYAD2   This PHY address is 4
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[19]]


set_property PACKAGE_PIN AB13 [get_ports {LEFT_CONNECTOR_A[19]}]
set_property PACKAGE_PIN AA13 [get_ports {LEFT_CONNECTOR_A[20]}]
set_property PACKAGE_PIN AB17 [get_ports {LEFT_CONNECTOR_A[21]}]
set_property PACKAGE_PIN AB16 [get_ports {LEFT_CONNECTOR_A[22]}]
set_property PACKAGE_PIN AA14 [get_ports {LEFT_CONNECTOR_A[23]}]
set_property PACKAGE_PIN Y13 [get_ports {LEFT_CONNECTOR_A[24]}]
set_property PACKAGE_PIN W16 [get_ports {LEFT_CONNECTOR_A[25]}]
set_property PACKAGE_PIN W15 [get_ports {LEFT_CONNECTOR_A[26]}]
set_property PACKAGE_PIN U16 [get_ports {LEFT_CONNECTOR_A[27]}]
set_property PACKAGE_PIN T16 [get_ports {LEFT_CONNECTOR_A[28]}]
set_property PACKAGE_PIN AB12 [get_ports {LEFT_CONNECTOR_A[29]}]
set_property PACKAGE_PIN AB11 [get_ports {LEFT_CONNECTOR_A[30]}]
set_property PACKAGE_PIN W14 [get_ports {LEFT_CONNECTOR_A[31]}]
set_property PACKAGE_PIN Y7 [get_ports {LEFT_CONNECTOR_A[32]}]
set_property PACKAGE_PIN Y8 [get_ports {LEFT_CONNECTOR_A[33]}]
set_property PACKAGE_PIN Y14 [get_ports {LEFT_CONNECTOR_A[34]}]
set_property PACKAGE_PIN AB10 [get_ports {LEFT_CONNECTOR_A[35]}]
set_property PACKAGE_PIN AA9 [get_ports {LEFT_CONNECTOR_A[36]}]
set_property PACKAGE_PIN AA11 [get_ports {LEFT_CONNECTOR_A[37]}]
set_property PACKAGE_PIN AA10 [get_ports {LEFT_CONNECTOR_A[38]}]

set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[19]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[20]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[21]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[22]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[23]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[24]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[25]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[26]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[27]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[28]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[29]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[30]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[31]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[32]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[33]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[34]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[35]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[36]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[37]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[38]}]

# pullup for power good
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[36]]
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[37]]
set_property PULLUP true [get_ports LEFT_CONNECTOR_A[38]]

set_property DRIVE 12 [get_ports {RIGHT_CONNECTOR_A[25]}]
set_property SLEW FAST [get_ports {RIGHT_CONNECTOR_A[25]}]

#----------------------------------------------------------------
# ARM MICRO
#----------------------------------------------------------------
set_property PACKAGE_PIN U15 [get_ports UC_ALE_IN]
set_property PACKAGE_PIN V15 [get_ports UC_REB_IN]
set_property PACKAGE_PIN T14 [get_ports UC_WEB_IN]
set_property PACKAGE_PIN T15 [get_ports UC_CSIB_IN]
set_property PACKAGE_PIN V10 [get_ports {UC_AD[0]}]
set_property PACKAGE_PIN W10 [get_ports {UC_AD[1]}]
set_property PACKAGE_PIN Y11 [get_ports {UC_AD[2]}]
set_property PACKAGE_PIN Y12 [get_ports {UC_AD[3]}]
set_property PACKAGE_PIN W11 [get_ports {UC_AD[4]}]
set_property PACKAGE_PIN W12 [get_ports {UC_AD[5]}]
set_property PACKAGE_PIN V13 [get_ports {UC_AD[6]}]
set_property PACKAGE_PIN V14 [get_ports {UC_AD[7]}]

set_property IOSTANDARD LVCMOS33 [get_ports UC_ALE_IN]
set_property IOSTANDARD LVCMOS33 [get_ports UC_REB_IN]
set_property IOSTANDARD LVCMOS33 [get_ports UC_WEB_IN]
set_property IOSTANDARD LVCMOS33 [get_ports UC_CSIB_IN]
set_property IOSTANDARD LVCMOS33 [get_ports {UC_AD[7]}]
set_property IOSTANDARD LVCMOS33 [get_ports {UC_AD[6]}]
set_property IOSTANDARD LVCMOS33 [get_ports {UC_AD[5]}]
set_property IOSTANDARD LVCMOS33 [get_ports {UC_AD[4]}]
set_property IOSTANDARD LVCMOS33 [get_ports {UC_AD[3]}]
set_property IOSTANDARD LVCMOS33 [get_ports {UC_AD[2]}]
set_property IOSTANDARD LVCMOS33 [get_ports {UC_AD[1]}]
set_property IOSTANDARD LVCMOS33 [get_ports {UC_AD[0]}]


# pins
set_property PACKAGE_PIN F15 [get_ports CLKREF_TCXO]
set_property IOSTANDARD LVCMOS15 [get_ports CLKREF_TCXO]
#set_property PACKAGE_PIN F21 [get_ports CLKREF25B]
#set_property IOSTANDARD LVCMOS15 [get_ports CLKREF25B]
set_property PACKAGE_PIN F20 [get_ports CLKREF_EXT]
set_property IOSTANDARD LVCMOS15 [get_ports CLKREF_EXT]
set_property PACKAGE_PIN AA15 [get_ports {LEFT_CONNECTOR_A[18]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_A[18]}]
set_property PACKAGE_PIN AB2 [get_ports {LEFT_CONNECTOR_B1[1]}]
set_property PACKAGE_PIN AB3 [get_ports {LEFT_CONNECTOR_B1[2]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B1[4]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B1[3]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B1[2]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B1[1]}]
set_property PACKAGE_PIN AA4 [get_ports {LEFT_CONNECTOR_B1[3]}]
set_property PACKAGE_PIN Y4 [get_ports {LEFT_CONNECTOR_B1[4]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B2[16]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B2[15]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B2[14]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B2[13]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B2[12]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B2[11]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B2[10]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B2[9]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B2[8]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B2[7]}]
set_property IOSTANDARD LVCMOS33 [get_ports {LEFT_CONNECTOR_B2[6]}]
set_property PACKAGE_PIN AB6 [get_ports {LEFT_CONNECTOR_B2[6]}]
set_property PACKAGE_PIN AB7 [get_ports {LEFT_CONNECTOR_B2[7]}]
set_property PACKAGE_PIN W5 [get_ports {LEFT_CONNECTOR_B2[8]}]
set_property PACKAGE_PIN W6 [get_ports {LEFT_CONNECTOR_B2[9]}]
#set_property PACKAGE_PIN Y7 [get_ports {LEFT_CONNECTOR_B2[10]}]
#set_property PACKAGE_PIN Y8 [get_ports {LEFT_CONNECTOR_B2[11]}]
#set_property PACKAGE_PIN Y14 [get_ports {LEFT_CONNECTOR_B2[12]}]
#set_property PACKAGE_PIN AB10 [get_ports {LEFT_CONNECTOR_B2[13]}]
#set_property PACKAGE_PIN AA9 [get_ports {LEFT_CONNECTOR_B2[14]}]
#set_property PACKAGE_PIN AA11 [get_ports {LEFT_CONNECTOR_B2[15]}]
#set_property PACKAGE_PIN AA10 [get_ports {LEFT_CONNECTOR_B2[16]}]

set_property PACKAGE_PIN W1 [get_ports {RIGHT_CONNECTOR_A[2]}]
set_property PACKAGE_PIN Y1 [get_ports {RIGHT_CONNECTOR_A[1]}]
set_property PACKAGE_PIN W4 [get_ports {RIGHT_CONNECTOR_A[3]}]
set_property PACKAGE_PIN V4 [get_ports {RIGHT_CONNECTOR_A[4]}]
set_property PACKAGE_PIN V8 [get_ports {RIGHT_CONNECTOR_A[5]}]
set_property PACKAGE_PIN V9 [get_ports {RIGHT_CONNECTOR_A[6]}]
set_property PACKAGE_PIN V2 [get_ports {RIGHT_CONNECTOR_A[7]}]
set_property PACKAGE_PIN U2 [get_ports {RIGHT_CONNECTOR_A[8]}]
set_property PACKAGE_PIN T5 [get_ports {RIGHT_CONNECTOR_A[10]}]
set_property PACKAGE_PIN U5 [get_ports {RIGHT_CONNECTOR_A[9]}]
set_property PACKAGE_PIN U1 [get_ports {RIGHT_CONNECTOR_A[11]}]
set_property PACKAGE_PIN T1 [get_ports {RIGHT_CONNECTOR_A[12]}]
set_property PACKAGE_PIN T4 [get_ports {RIGHT_CONNECTOR_A[13]}]
set_property PACKAGE_PIN R4 [get_ports {RIGHT_CONNECTOR_A[14]}]
set_property PACKAGE_PIN P1 [get_ports {RIGHT_CONNECTOR_A[15]}]
set_property PACKAGE_PIN R1 [get_ports {RIGHT_CONNECTOR_A[16]}]
set_property PACKAGE_PIN P4 [get_ports {RIGHT_CONNECTOR_A[17]}]
set_property PACKAGE_PIN P5 [get_ports {RIGHT_CONNECTOR_A[18]}]
set_property PACKAGE_PIN N5 [get_ports {RIGHT_CONNECTOR_A[19]}]
set_property PACKAGE_PIN P6 [get_ports {RIGHT_CONNECTOR_A[20]}]
set_property PACKAGE_PIN M5 [get_ports {RIGHT_CONNECTOR_A[21]}]
set_property PACKAGE_PIN M6 [get_ports {RIGHT_CONNECTOR_A[22]}]
set_property PACKAGE_PIN K3 [get_ports {RIGHT_CONNECTOR_A[23]}]
set_property PACKAGE_PIN L3 [get_ports {RIGHT_CONNECTOR_A[24]}]
set_property PACKAGE_PIN J1 [get_ports {RIGHT_CONNECTOR_A[25]}]
set_property PACKAGE_PIN K1 [get_ports {RIGHT_CONNECTOR_A[26]}]
set_property PACKAGE_PIN J4 [get_ports {RIGHT_CONNECTOR_A[27]}]
set_property PACKAGE_PIN K4 [get_ports {RIGHT_CONNECTOR_A[28]}]
set_property PACKAGE_PIN H5 [get_ports {RIGHT_CONNECTOR_A[29]}]
set_property PACKAGE_PIN J5 [get_ports {RIGHT_CONNECTOR_A[30]}]
set_property PACKAGE_PIN G3 [get_ports {RIGHT_CONNECTOR_A[31]}]
set_property PACKAGE_PIN H3 [get_ports {RIGHT_CONNECTOR_A[32]}]
set_property PACKAGE_PIN E3 [get_ports {RIGHT_CONNECTOR_A[33]}]
set_property PACKAGE_PIN F3 [get_ports {RIGHT_CONNECTOR_A[34]}]
set_property PACKAGE_PIN D2 [get_ports {RIGHT_CONNECTOR_A[35]}]
set_property PACKAGE_PIN E2 [get_ports {RIGHT_CONNECTOR_A[36]}]
set_property PACKAGE_PIN B2 [get_ports {RIGHT_CONNECTOR_A[37]}]
set_property PACKAGE_PIN C2 [get_ports {RIGHT_CONNECTOR_A[38]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[38]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[37]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[36]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[35]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[34]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[33]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[32]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[31]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[30]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[29]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[28]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[27]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[26]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[25]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[24]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[23]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[22]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[21]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[20]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[19]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[18]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[17]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[16]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[15]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[14]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[13]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[12]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[11]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[10]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[9]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[8]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[7]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[6]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[5]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[4]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[3]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[2]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_A[1]}]

set_property PACKAGE_PIN Y2 [get_ports {RIGHT_CONNECTOR_B1[1]}]
set_property PACKAGE_PIN W2 [get_ports {RIGHT_CONNECTOR_B1[2]}]
set_property PACKAGE_PIN W7 [get_ports {RIGHT_CONNECTOR_B1[3]}]
set_property PACKAGE_PIN V7 [get_ports {RIGHT_CONNECTOR_B1[4]}]
set_property PACKAGE_PIN V5 [get_ports {RIGHT_CONNECTOR_B2[6]}]
set_property PACKAGE_PIN U6 [get_ports {RIGHT_CONNECTOR_B2[7]}]
set_property PACKAGE_PIN V3 [get_ports {RIGHT_CONNECTOR_B2[8]}]
set_property PACKAGE_PIN U3 [get_ports {RIGHT_CONNECTOR_B2[9]}]
set_property PACKAGE_PIN R2 [get_ports {RIGHT_CONNECTOR_B2[10]}]
set_property PACKAGE_PIN R3 [get_ports {RIGHT_CONNECTOR_B2[11]}]
set_property PACKAGE_PIN T6 [get_ports {RIGHT_CONNECTOR_B2[12]}]
set_property PACKAGE_PIN R6 [get_ports {RIGHT_CONNECTOR_B2[13]}]
set_property PACKAGE_PIN N2 [get_ports {RIGHT_CONNECTOR_B2[14]}]
set_property PACKAGE_PIN P2 [get_ports {RIGHT_CONNECTOR_B2[15]}]
set_property PACKAGE_PIN N3 [get_ports {RIGHT_CONNECTOR_B2[16]}]
set_property PACKAGE_PIN N4 [get_ports {RIGHT_CONNECTOR_B2[17]}]
set_property PACKAGE_PIN M2 [get_ports {RIGHT_CONNECTOR_B2[18]}]
set_property PACKAGE_PIN M3 [get_ports {RIGHT_CONNECTOR_B2[19]}]
set_property PACKAGE_PIN L1 [get_ports {RIGHT_CONNECTOR_B3[21]}]
set_property PACKAGE_PIN M1 [get_ports {RIGHT_CONNECTOR_B3[22]}]
set_property PACKAGE_PIN L4 [get_ports {RIGHT_CONNECTOR_B3[23]}]
set_property PACKAGE_PIN L5 [get_ports {RIGHT_CONNECTOR_B3[24]}]
set_property PACKAGE_PIN J2 [get_ports {RIGHT_CONNECTOR_B3[25]}]
set_property PACKAGE_PIN K2 [get_ports {RIGHT_CONNECTOR_B3[26]}]
set_property PACKAGE_PIN J6 [get_ports {RIGHT_CONNECTOR_B3[27]}]
set_property PACKAGE_PIN K6 [get_ports {RIGHT_CONNECTOR_B3[28]}]
set_property PACKAGE_PIN G2 [get_ports {RIGHT_CONNECTOR_B3[29]}]
set_property PACKAGE_PIN H2 [get_ports {RIGHT_CONNECTOR_B3[30]}]
set_property PACKAGE_PIN G4 [get_ports {RIGHT_CONNECTOR_B4[32]}]
set_property PACKAGE_PIN H4 [get_ports {RIGHT_CONNECTOR_B4[33]}]
set_property PACKAGE_PIN F1 [get_ports {RIGHT_CONNECTOR_B4[34]}]
set_property PACKAGE_PIN G1 [get_ports {RIGHT_CONNECTOR_B4[35]}]
set_property PACKAGE_PIN D1 [get_ports {RIGHT_CONNECTOR_B4[36]}]
set_property PACKAGE_PIN E1 [get_ports {RIGHT_CONNECTOR_B4[37]}]
set_property PACKAGE_PIN A1 [get_ports {RIGHT_CONNECTOR_B4[38]}]
set_property PACKAGE_PIN B1 [get_ports {RIGHT_CONNECTOR_B4[39]}]
set_property DRIVE 12 [get_ports {RIGHT_CONNECTOR_B3[29]}]
set_property DRIVE 12 [get_ports {RIGHT_CONNECTOR_B3[30]}]
set_property SLEW FAST [get_ports {RIGHT_CONNECTOR_B3[29]}]
set_property SLEW FAST [get_ports {RIGHT_CONNECTOR_B3[30]}]


set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B1[1]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B1[2]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B1[3]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B1[4]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[6]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[7]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[8]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[9]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[10]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[11]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[12]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[13]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[14]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[15]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[16]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[17]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[18]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B2[19]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B3[21]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B3[22]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B3[23]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B3[24]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B3[25]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B3[26]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B3[27]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B3[28]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B3[29]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B3[30]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B4[32]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B4[33]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B4[34]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B4[35]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B4[36]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B4[37]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B4[38]}]
set_property IOSTANDARD LVCMOS33 [get_ports {RIGHT_CONNECTOR_B4[39]}]
